%gatingwrapper is a script that guides the user through processing
%and analyzing a group of gating current ephys traces obtained by GPatch, using
%datreader

%Read in the file
h3=msgbox('Please choose a gating file.');
rawdata=datreader('d','a','g');
name='d';
delete(h3);

%Select a group
prompt= 'What is the gating group number?  ';
group=input(prompt);
groupinfo=rawdata.(['group' num2str(group)]);

%Segment out parts of name for variable labelling
filenameglobal=strsplit(filenameglobal, '.');
filenameglobal=filenameglobal{1,1};

%Now format the name so it works as a matlab variable (no blank spaces, must start with
%letter) (In retrospect, I could have tried genvarname, but this seems to
%work quite well
filenameglobal=filenameglobal(filenameglobal~=' '); %Remove spaces
expression='[0123456789]'; %Set variable of all numerals
startIndex=regexp(filenameglobal,expression);
%Matlab variables must start with a letter, so if there is a number at the
%start of the filename, put an 'a' at the beginning of it
if startIndex(1,1)==1
    s1='a';
    filenameglobal=strcat(s1,filenameglobal,'_',num2str(group));
end


%Initialize data variables
num_sweeps=size(groupinfo,2); %Find number of sweeps in the group
num_points=size(groupinfo(1).data,1); %Find number of points in the sweep
groupdata=zeros([num_points num_sweeps]); %Preallocate group data variable for speed
groupvoltage=zeros([1 num_sweeps]); %Preallocate voltage data variable for speed

%This gets all the traces and puts them into a single array
for i=1:num_sweeps
    groupdata(:,i)=groupinfo(i).data;
    groupvoltage(:,i)=groupinfo(i).amp(2);
end

%Initialize pulse times
dur1=groupinfo(1).dur(1); %Duration of first pulse
dur2=groupinfo(1).dur(2); %duration of second pulse
dur3=groupinfo(1).dur(3); %Duration of third pulse
trig1pulse=groupinfo.trig1pulse; %Pulse that trigger is based off of
trig1delay=groupinfo.delay; %Delay of pulse
acq_period=groupinfo.acqrate; %Acquision rate (us per point)

%T0 is time zero, where the acquisition window starts. T1 is the end of the
%first time section (trigger delay and duration of the first pulse), and is
%equivalent to the beginning of the second pulse, which is the typical
%variable pulse in GPatch. T2 is the end of the second pulse/ beginning of the third pulse, and T3 is the
%end of the third pulse.
if trig1pulse==1
    T1=dur1+trig1delay;
    T2=dur1+dur2+trig1delay;
    T3=dur1+dur2+dur3+trig1delay;
elseif trig1pulse==2
    prompt= 'What is the trigger delay (in ms)?   ';
    trig1delay=input(prompt)*1000;
    T1=trig1delay;
    T2=dur2+trig1delay;
    T3=dur2+dur3+trig1delay;
end

%Allow user to choose for no baseline or linear baseline
export_data=menu('Choose a baseline type','No baseline', 'Linear baseline');
if export_data==1

    %Gating_examine_start and _end provide values that are read into integrate
    %as the intLimits value
    default_gating_examine_start=(T1/1000)+0.5;
    default_gating_examine_end=(T2*3/4)/1000;
    default_gating_fit_start=(T1/1000)+3;

    %Now initialize values for the dialog box for no baselining
    gating_initialvalues_prompt = {'Gating integration start', 'Gating integration end', 'Gating fit start'};
    dlg_gatingtitle = 'Gating Initial Parameters';
    num_lines=1;
    default_gating = {num2str(default_gating_examine_start), num2str(default_gating_examine_end), num2str(default_gating_fit_start)};
    gatinganswer=inputdlg(gating_initialvalues_prompt,dlg_gatingtitle,num_lines,default_gating);

    %Now take data from dialog box and write new variables, converting into
    %points for integrate
    gating_examine_start = round(str2double(gatinganswer{1})*1000/acq_period);
    gating_examine_end = round(str2double(gatinganswer{2})*1000/acq_period);
    %Note that gating_fit_start actually acts as an exclusion on top of the
    %baselined data. Therefore, we subtract the gating_examine_start variable
    %from it, to account for it correctly
    gating_fit_start=round(str2double(gatinganswer{3})*1000/acq_period)-gating_examine_start;

    %Use these variables to feed into integratenobaseline
    intLimits_values=[gating_examine_start gating_examine_end];
    fitLimits_values=gating_fit_start;

    %Run integratenobaseline
    [qv, corrected_data,integrated_data]=integratenobaseline(groupdata, intLimits_values, acq_period);

else
    %This code is for baselining
    %Gating_baseline_start and _end provide values (which can be changed
    %by the user) that are read into integrate as the fitLimits value.
    default_gating_baseline_start= (T2/1000)-((T2/5)/1000);
    default_gating_baseline_end= (T2/1000)-1;
    %Gating_examine_start and _end provide values that are read into integrate
    %as the intLimits value
    default_gating_examine_start=(T1/1000)+0.5;
    default_gating_fit_start=(T1/1000)+3;
    default_gating_examine_end=(T2*3/4)/1000;

    %Now initialize values for the dialog box
    gating_initialvalues_prompt = {'Gating baseline start','Gating baseline end','Gating integration start', 'Gating integration end', 'Gating fit start'};
    dlg_gatingtitle = 'Gating Initial Parameters';
    num_lines=1;
    default_gating = {num2str(default_gating_baseline_start), num2str(default_gating_baseline_end), num2str(default_gating_examine_start), num2str(default_gating_examine_end), num2str(default_gating_fit_start)};
    gatinganswer=inputdlg(gating_initialvalues_prompt,dlg_gatingtitle,num_lines,default_gating);

    %Now take data from dialog box and write new variables, converting into
    %points for integrate
    gating_baseline_start= round(str2double(gatinganswer{1})*1000/acq_period);
    gating_baseline_end = round(str2double(gatinganswer{2})*1000/acq_period);
    gating_examine_start = round(str2double(gatinganswer{3})*1000/acq_period);
    gating_examine_end = round(str2double(gatinganswer{4})*1000/acq_period);
    %Note that gating_fit_start actually acts as an exclusion on top of the
    %baselined data. Therefore, we subtract the gating_examine_start variable
    %from it, to account for it correctly
    gating_fit_start=round(str2double(gatinganswer{5})*1000/acq_period)-gating_examine_start;

    %Use these variables to feed into integrate
    intLimits_values=[gating_examine_start gating_examine_end];
    baselineLimits_values=[gating_baseline_start gating_baseline_end];
    fitLimits_values=gating_fit_start;

    %Run integrate
    [qv, corrected_data, integrated_data]=integrate(groupdata, intLimits_values,baselineLimits_values,acq_period);

    %Ask the user if they are happy with the baseline, if not error out and
    %return to start (this is another place for potential improvement so
    %that the user does not have to go all the way back to the beginning)
    baseline_check=menu('Are you happy with this baseline?','Yes', 'No');
    if baseline_check==2
        error('Sorry, try again')
    end
end

%%%%%%%%%%%%%%And now back to commands common to both non-baselined and baselined
%data%%%%%%%%%%%%

%Initialize fvdelayfit variables (basically, the time array)
time=(groupinfo(1).time(intLimits_values(1):intLimits_values(2))-(intLimits_values(1)-1)*acq_period)/1000;

%Run qvdelayfits
fit_1exp=qvdelayfit(time,corrected_data, fitLimits_values);
fit_2exp=qvdelayfit2exp(time,corrected_data, fitLimits_values);

%Add data to structured array by file name
q_data.qvoltage.(filenameglobal)=groupvoltage';
q_data.qvs.(filenameglobal)=qv;
q_data.qcorrected.(filenameglobal)=corrected_data;
q_data.qfits_1exp.(filenameglobal)=fit_1exp;
q_data.qfits_2exp.(filenameglobal)=fit_2exp;
q_data.qintegrated.(filenameglobal)=integrated_data;


%Now ask the user if they want to export data, and if yes, use
%data_exporter to do so
export_data=menu('Do you want to export data to excel?','Yes', 'No');
if export_data==1
    gating_data_exporter(q_data);
end
